/**
* \file: partition_list.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMM_MODEL_PARTITION_LIST_H
#define AMM_MODEL_PARTITION_LIST_H

#include "model/device.h"
#include "model/partition.h"

// defines member functions used to create and manage a list of partitions of a device

// definition of an iterator used to iterate through the list
typedef void* partition_iterator_t;

//add partitions to a device. The device is identified either by a reference or the id
partition_t *device_add_partition_by_device(device_t *device, const char *partition_id, partition_metadata_t *metadata);

partition_t *device_add_partition_by_device_id(const char *device_id, const char *partition_id,
		partition_metadata_t *metadata);

//removes the partition from its device
void device_delete_partition(partition_t *partition);

//find the partition with given id in the list of partitions of a device and returns its reference
partition_t *device_find_partition(device_t *device, const char *partition_id);

//finds the partition with given id in the lists of partitions of all devices managed by the automounter at the moment
partition_t* device_list_find_partition_by_id(const char *partition_id);

//finds the partition with given mountpoint in the lists of partitions of all devices managed by the automounter at the moment
partition_t* device_list_find_partition_by_mountpoint(const char *mount_point);


//returns the first partition in the list of partitions of a device. A pointer to an iterator might be passed to iterate
//through the list
partition_t *device_first_partition(device_t *device, partition_iterator_t *iterator);

//returns the next partition in the list of partitions of a device
partition_t *device_next_partition(partition_iterator_t *iterator);


partition_t *device_first_mounted_partition(device_t *device, partition_iterator_t *iterator);

partition_t *device_next_mounted_partition(partition_iterator_t *iterator);

partition_t *device_list_first_mounted_partition(partition_iterator_t *iterator);

partition_t *device_list_next_mounted_partition(partition_iterator_t *iterator);


#endif
